/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.client.circuit;

import com.technicalitiesmc.lib.circuit.component.ComponentType;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderType;

public class ComponentRenderTypes {
    private static final Set<RenderType> REQUESTED_TYPES = new HashSet<RenderType>();
    private static final Map<ComponentType, Predicate<RenderType>> RENDER_TYPES = new IdentityHashMap<ComponentType, Predicate<RenderType>>();

    public static void requestRenderType(RenderType type) {
        REQUESTED_TYPES.add(type);
    }

    public static Set<RenderType> getRequestedTypes() {
        return REQUESTED_TYPES;
    }

    public static void setRenderType(ComponentType component, RenderType type) {
        ComponentRenderTypes.setRenderTypeFilter(component, t -> t == type);
        ComponentRenderTypes.requestRenderType(type);
    }

    public static void setRenderTypeFilter(ComponentType component, Predicate<RenderType> predicate) {
        RENDER_TYPES.put(component, predicate);
    }

    public static boolean shouldRender(ComponentType component, RenderType type) {
        return RENDER_TYPES.getOrDefault((Object)component, ComponentRenderTypes::isSolid).test(type);
    }

    private static boolean isSolid(RenderType type) {
        return type == RenderType.m_110451_();
    }

    static {
        REQUESTED_TYPES.add(RenderType.m_110451_());
    }
}

